@extends('admin.layout.page-app')
@section('page_title', __('Label.Dashboard'))
@section('tab_title', __('Label.Dashboard'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('Label.Dashboard')}}</h1>

            <!-- Counter -->
            <div class="row counter-row">
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color6-card">
                        <i class="fa-solid fa-users fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color6-viewall" href="{{ route('user.index')}}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($UserCount ?? 0)}}">{{No_Format($UserCount ?? 0)}}</p>
                            <span>{{__('Label.Users')}}</span>
                        </h2>
                    </div>
                </div>
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color7-card">
                        <i class="fa-solid fa-user-tie fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color7-viewall" href="{{route('creator.index')}}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($CreatorCount ?? 0)}}">{{No_Format($CreatorCount ?? 0)}}</p>
                            <span>{{__('Label.Creator')}}</span>
                        </h2>
                    </div>
                </div>
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color8-card">
                        <i class="fa-solid fa-video fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color8-viewall" href="{{ route('post.index')}}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($VideoCount ?? 0)}}">{{No_Format($VideoCount ?? 0)}}</p>
                            <span>{{__('Label.Videos')}}</span>
                        </h2>
                    </div>
                </div>
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color9-card">
                        <i class="fa-solid fa-image fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color9-viewall" href="{{route('post.index')}}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($ImageCount ?? 0)}}">{{No_Format($ImageCount ?? 0)}}</p>
                            <span>{{__('Label.Image')}}</span>
                        </h2>
                    </div>
                </div>
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color10-card">
                        <i class="fa-solid fa-hashtag fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color10-viewall" href="{{ route('hashtag.index') }}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($HashtagCount ?: 00)}}">{{No_Format($HashtagCount ?: 00)}}</p>
                            <span>{{__('Label.Hashtag')}}</span>
                        </h2>
                    </div>
                </div>
            </div>

            <!-- Join User Statistice && Most View Post -->
            <div class="row">
                <div class="col-12 col-xl-8">
                    <div class="box-title">
                        <h2 class="title">{{__('Label.join_users_statistice')}}</h2>
                        <a href="{{ route('user.index') }}" class="btn btn-link">{{__('Label.View_All')}}</a>
                    </div>
                    <div class="row mt-2 mb-2">
                        <div class="col-12 col-sm-12">
                            <Button id="year" class="btn btn-default">{{__('Label.this_year')}}</Button>
                            <Button id="month" class="btn btn-default">{{__('Label.this_month')}}</Button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12 col-sm-12">
                            <canvas id="UserChart" width="100%" height="38px" style="background-color: #f9faff;"></canvas>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-xl-4">
                    <div class="video-box">
                        <div class="box-title mt-0">
                            <h2 class="title">{{__('Label.most_viewed_post')}}</h2>
                        </div>
                        @if(isset($most_view_video) && $most_view_video != null)
                        <div class="p-3 bg-white mt-4">
                            <img src="{{ $most_view_video['image'] }}" class="img-fluid d-block mx-auto img-thumbnail" style="height: 300px; width: 100%;" />
                            <div class="box-title box-border-0">
                                <h5 class="f600" style="display: inline-block; text-overflow:ellipsis; white-space:nowrap; overflow:hidden; width:75%;">{{ $most_view_video['title']}}</h5>
                                <div class="d-flex justify-content-between">
                                    <i class="fa-regular fa-eye fa-xl mr-3" style="color:#4e45b8; margin-top:12px"></i>
                                    <h5 class="counting" data-count="{{No_Format($most_view_video['view'] ?? 0)}}">{{No_Format($most_view_video['view'] ?? 0)}} </h5>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Top Creator -->
            <div class="row">
                <div class="col-12">
                    <div class="box-title">
                        <h2 class="title">{{__('Label.top_creators')}}</h2>
                        <a href="{{ route('creator.index')}}" class="btn btn-link">{{__('Label.View_All')}}</a>
                    </div>
                    <div class="row artist-row">
                        @if(isset($top_creators) && $top_creators != null)
                        @for ($i = 0; $i < count($top_creators); $i++) <div class="col-6 col-md-2">
                            <div class="artist-grid-card">
                                <span class="avatar-control">
                                    @isset($top_creators[$i]->image )
                                    <img src="{{ $top_creators[$i]->image }}" class="img-thumbnail" style="height: 180px; width: 100%; border-radius: 25px" />
                                    @else
                                    <img src="{{ asset('assets/imgs/default.png') }}" class="img-thumbnail" style="height: 180px; width: 100%; border-radius: 25px" />
                                    @endif
                                </span>
                                <h3 class="name" style="display: inline-block; text-overflow:ellipsis; white-space:nowrap; overflow:hidden; width:100%;">{{ $top_creators[$i]->full_name ?? "-" }}</h3>
                                <p class="post mb-0">{{ String_Cut($top_creators[$i]->bio, 30) }}</p>
                            </div>
                    </div>

                    @if($i == 5)
                    @break;
                    @endif
                    @endfor
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- chart -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.js"></script>
    
    <script>

        var month = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        
        // User Statistice
        var cData = JSON.parse(`<?php echo $user_year; ?>`);
        var ctx = $("#UserChart");

        var data = {
            labels: month,
            datasets: [{
                label: 'Users',
                data: cData['sum'],
                backgroundColor: '#4e45b8',
            }],
        };
        var options = {
            responsive: true,
            title: {
                display: true,
                position: "top",
                text: "{{__('Label.join_users_statistice_current_year')}}",
                fontSize: 18,
                fontColor: "#000"
            },
            legend: {
                title: "text",
                display: true,
                position: 'top',
                labels: {
                    fontSize: 16,
                    fontColor: "#000000",
                }
            },
            scales: {
                yAxes: [{
                    scaleLabel: {
                        display: true,
                        labelString: 'Total Count',
                        fontSize: 16,
                        fontColor: "#000000",
                    },
                }],
                xAxes: [{
                    scaleLabel: {
                        display: true,
                        labelString: 'Month',
                        fontSize: 16,
                        fontColor: "#000000",
                    }
                }]
            }
        };
        var chart1 = new Chart(ctx, {
            type: "bar",
            data: data,
            options: options
        });

        $("#year").on("click", function() {
            chart1.destroy();

            chart1 = new Chart(ctx, {
                type: "bar",
                data: data,
                options: options

            });
        });
        $("#month").on("click", function() {

            var date = new Date();
            var currentYear = date.getFullYear();
            var currentMonth = date.getMonth() + 1;
            const getDays = (year, month) => new Date(year, month, 0).getDate();
            const days = getDays(currentYear, currentMonth);

            var all1 = [];
            for (let i = 0; i < days; i++) {
                all1.push(i + 1);
            }

            chart1.destroy();
            var cData = JSON.parse(`<?php echo $user_month ?>`);

            var data = {
                labels: all1,
                datasets: [{
                    label: 'Users',
                    data: cData['sum'],
                    backgroundColor: '#4e45b8',
                }],
            };
            var options = {
                responsive: true,
                title: {
                    display: true,
                    position: "top",
                    text: "{{__('Label.join_users_statistice_current_month')}}",
                    fontSize: 18,
                    fontColor: "#000"
                },
                legend: {
                    title: "text",
                    display: true,
                    position: 'top',
                    labels: {
                        fontSize: 16,
                        fontColor: "#000000",
                    }
                },
                scales: {
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Total Count',
                            fontSize: 16,
                            fontColor: "#000000",
                        },
                    }],
                    xAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Date',
                            fontSize: 16,
                            fontColor: "#000000",
                        }
                    }]
                }
            };
            chart1 = new Chart(ctx, {
                type: "bar",
                data: data,
                options: options,
            });
        });
    </script>
@endsection