<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Common;
use App\Models\Creator_Package;
use App\Models\Creator_Package_Transaction;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Facades\Validator;

class CreatorTransactionController extends Controller
{
    private $folder = "user";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index(Request $request)
    {
        try {

            $this->common->package_expiry();

            $params['data'] = [];
            $params['creator'] = User::where('is_creator', 1)->latest()->get();
            $params['user'] = User::where('is_creator', 0)->latest()->get();
            if ($request->ajax()) {

                $input_type = $request['input_type'];
                $input_search = $request['input_search'];
                $input_creator = $request['input_creator'];

                $query = Creator_Package_Transaction::query();

                if (!empty($input_search)) {
                    $query->where('transaction_id', 'LIKE', "%{$input_search}%");
                }

                if ($input_type == "today") {
                    $query->whereDay('created_at', date('d'))->whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'));
                } elseif ($input_type == "month") {
                    $query->whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'));
                } elseif ($input_type == "year") {
                    $query->whereYear('created_at', date('Y'));
                }
                
                if ($input_creator != "all") {
                    $query->where('to_user_id', $input_creator);
                }

                $data = $query->with('creator_package', 'user', 'creator')->latest()->get();

                for ($i = 0; $i < count($data); $i++) {
                    if($data[$i]['user'] != null){

                        $this->common->imageNameToUrl(array($data[$i]['user']), 'image', $this->folder);
                        $data[$i]['date'] = date("Y-m-d", strtotime($data[$i]['created_at']));
                    }
                }

                return DataTables()::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function ($row) {

                        $creator_transaction_delete = __('Label.delete_creator_transaction');

                        $delete = '<form onsubmit="return confirm(\'' . $creator_transaction_delete . '\');" method="POST" action="' . route('creator_transaction.destroy', [$row->id]) . '">
                        <input type="hidden" name="_token" value="' . csrf_token() . '">
                        <input type="hidden" name="_method" value="DELETE">
                        <button type="submit" class="edit-delete-btn" style="outline: none;"><i class="fa-solid fa-trash-can fa-xl"></i></button></form>';

                        $btn = '<div class="d-flex justify-content-around">';
                        $btn .= $delete;
                        $btn .= '</div>';
                        return $btn;
                    })
                    ->addColumn('status', function ($row) {
                        if ($row->status == 1) {
                            return "<button type='button' style='background:#058f00; font-weight:bold; border: none; color: white; padding: 4px 20px; outline: none;'>" . __('Label.Active') . "</button>";
                        } else {
                            return "<button type='button' style='background:#e3000b; font-weight:bold; border: none; color: white; padding: 5px 15px; outline: none;'>" . __('Label.expiry') . "</button>";
                        }
                    })
                    ->rawColumns(['action', 'status'])
                    ->make(true);
            }
            return view('admin.creator_transaction.index', $params);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function destroy($id)
    {
        try {

            Creator_Package_Transaction::where('id', $id)->delete();
            return redirect()->route('creator_transaction.index')->with('success', __('Label.data_delete_successfully'));
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
