<?php

namespace App\Http\Controllers\Socket;

use App\Http\Controllers\Controller;
use App\Models\Common;
use App\Models\Creator_Package_Transaction;
use App\Models\Gift;
use App\Models\Live_History;
use App\Models\Live_User;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;

class SocketController extends Controller
{
    private $folder = "user";
    private $folder_gift = "gift";
    public $common;
    public function __construct()
    {
        $this->common = new Common();
    }

    // addlivehistory
    public function addLiveHistory(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required',
                    'room_id' => 'required',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'room_id.required' => __('api_msg.room_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $userId = $request->user_id;
            $roomId = $request->room_id;

            // Delete Data
            Live_User::where('user_id', $userId)->delete();

            // Insert Live History
            $addHistory = new Live_History();
            $addHistory['room_id'] = $roomId;
            $addHistory['user_id'] = $userId;
            $addHistory['total_gift'] = 0;
            $addHistory['total_join_user'] = 0;
            $addHistory['total_live_chat'] = 0;
            $addHistory['start_time'] = date('Y-m-d H:i:s');
            $addHistory['end_time'] = "";
            $addHistory['duration'] = 0;
            $addHistory['status'] = 1;
            $addHistory->save();

            // Insert Live User
            $addUser = new Live_User();
            $addUser['room_id'] = $roomId;
            $addUser['user_id'] = $userId;
            $addUser['total_view'] = 0;
            $addUser['status'] = 1;
            $addUser->save();

            // Send Notification
            // $this->common->goLiveSendNotification($userId);
            $sub_users = Creator_Package_Transaction::where('to_user_id', $userId)->where('status', 1)->get()->toArray();
            if (count($sub_users) > 0) {
                $user_ids = array_column($sub_users, 'user_id');

                $users = User::whereIn('id', $user_ids)->get();
                $creator = User::where('id', $userId)->first();
                foreach ($users as $value) {

                    if (isset($value) && $value != null && $value['user_id'] != $creator['id']) {

                        $title = $creator['full_name'] . " " . __('Label.just_went_live_join_now_and_interact');
                        $this->common->save_notification(6, $creator['id'], $value['id'], 0, $title);
                    }
                }
            }

            return $this->common->API_Response(200, __('api_msg.add_record_successfully'));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    // endlive
    public function endLive(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required',
                    'room_id' => 'required',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'room_id.required' => __('api_msg.room_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $userId = $request->user_id;
            $roomId = $request->room_id;

            // Delete Live User
            Live_User::where('user_id', $userId)->delete();

            // Update Live History
            $data = Live_History::where('user_id', $userId)->where('room_id', $roomId)->latest()->first();
            if (isset($data)) {

                $data['end_time'] = date('Y-m-d H:i:s');
                $data['duration'] = strtotime($data['end_time']) - strtotime($data['start_time']);
                $data->save();
            }
            return $this->common->API_Response(200, __('api_msg.status_update_successfully'));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    // addView
    public function addView(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required',
                    'room_id' => 'required',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'room_id.required' => __('api_msg.room_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $userId = $request->user_id;
            $roomId = $request->room_id;

            // Update Live User
            Live_User::where('room_id', $roomId)->latest()->increment('total_view');

            // Update Live History
            Live_History::where('room_id', $roomId)->latest()->increment('total_join_user');

            // Retrieve the updated live count for response
            $updatedHistory = Live_History::where('room_id', $roomId)->latest()->first();

            return $this->common->API_Response(200, __('api_msg.add_record_successfully'), ['live_count' => $updatedHistory->total_join_user ?? 0]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    // lessView
    public function lessView(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required',
                    'room_id' => 'required',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'room_id.required' => __('api_msg.room_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $userId = $request->user_id;
            $roomId = $request->room_id;

            // Update Live User
            Live_User::where('room_id', $roomId)->latest()->decrement('total_view');

            // Update Live History
            Live_History::where('room_id', $roomId)->latest()->decrement('total_join_user');

            // Retrieve the updated live count for response
            $updatedHistory = Live_History::where('room_id', $roomId)->latest()->first();

            return $this->common->API_Response(200, __('api_msg.add_record_successfully'), ['live_count' => $updatedHistory->total_join_user ?? 0]);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    // liveChat
    public function liveChat(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required',
                    'room_id' => 'required',
                    'comment' => 'required',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'room_id.required' => __('api_msg.room_id_is_required'),
                    'comment.required' => __('api_msg.comment_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $userId = $request->user_id;
            $roomId = $request->room_id;
            $comment = $request->comment;

            // Update Live History
            Live_History::where('room_id', $roomId)->latest()->increment('total_live_chat');

            $user = User::where('id', $userId)->latest()->first();
            if (isset($user)) {

                $data['user_name'] = $user['user_name'];
                $data['full_name'] = $user['full_name'];
                $data['image'] = $this->common->getImage($this->folder, $user['image']);
                $data['comment'] = $comment;

                return $this->common->API_Response(200, __('api_msg.add_record_successfully'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function sendGift(Request $request)
    {
        try {
            $validation = Validator::make(
                $request->all(),
                [
                    'user_id' => 'required',
                    'room_id' => 'required',
                    'gift_id' => 'required',
                ],
                [
                    'user_id.required' => __('api_msg.user_id_is_required'),
                    'room_id.required' => __('api_msg.room_id_is_required'),
                    'gift_id.required' => __('api_msg.gift_id_is_required'),
                ]
            );
            if ($validation->fails()) {
                $data['status'] = 400;
                $data['message'] = $validation->errors()->first();
                return $data;
            }

            $userId = $request->user_id;
            $roomId = $request->room_id;
            $giftId = $request->gift_id;

            // Update Live History
            Live_History::where('room_id', $roomId)->latest()->increment('total_gift');

            // Gift
            $gift = Gift::where('id', $giftId)->first();
            $user = User::where('id', $userId)->first();
            $live_user = Live_User::where('room_id', $roomId)->first();

            if (isset($gift) && isset($user) && isset($live_user)) {

                if($user['coin_wallet'] >= $gift['coin']){

                    User::where('id', $userId)->decrement('coin_wallet', $gift['coin']);
                    User::where('id', $live_user['user_id'])->increment('earned_coin', $gift['coin']);
    
                    $data['name'] = $gift['name'];
                    $data['image'] = $this->common->getImage($this->folder_gift, $gift['image']);
                } else {
                    return $this->common->API_Response(400, __('api_msg.gift_sending_failed_your_coin_balance_is_too_low'));
                }

                return $this->common->API_Response(200, __('api_msg.add_record_successfully'), $data);
            } else {
                return $this->common->API_Response(400, __('api_msg.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}
