@extends('admin.layout.page-app')
@section('page_title', __('Label.earning_dashboard'))
@section('tab_title', __('Label.earning_dashboard'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('Label.earning_dashboard')}}</h1>


            <!-- Counter -->
            <div class="row counter-row">
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color1-card">
                        <i class="fa-solid fa-circle-dollar-to-slot fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color1-viewall" href="{{ route('coin_transaction.index')}}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($CoinTransactionCount ?? 0)}}">{{No_Format($CoinTransactionCount ?? 0)}}</p>
                            <span> {{__('Label.coin_transactions')}} {{__('Label.earnings')}} ({{Currency_Code()}})</span>
                        </h2>
                    </div>
                </div>
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color2-card">
                        <i class="fa-solid fa-circle-dollar-to-slot fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color2-viewall" href="{{route('coin_transaction.index')}}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($CoinCurrentMounthCount ?? 0)}}">{{No_Format($CoinCurrentMounthCount ?? 0)}}</p>
                            <span>{{__('Label.coin_transactions')}} {{__('Label.monthly_earnings')}} ({{Currency_Code()}})</span>
                        </h2>
                    </div>
                </div>
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color3-card">
                        <i class="fa-solid fa-box fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color3-viewall" href="{{ route('coin_package.index')}}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($CoinPackageCount ?? 0)}}">{{No_Format($CoinPackageCount ?? 0)}}</p>
                            <span>{{__('Label.coin_package')}}</span>
                        </h2>
                    </div>
                </div>
            </div>
            <!-- Counter -->
            <div class="row counter-row">
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color6-card">
                        <i class="fa-solid fa-wallet fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color6-viewall" href="{{ route('creator_transaction.index')}}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter mt-4">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($CoinTransactionCount) ?? 0}}">{{No_Format($CoinTransactionCount) ?? 0}}</p>
                            <span>{{__('Label.creator_transactions')}} {{__('Label.earnings')}} ({{Currency_Code()}})</span>
                        </h2>
                    </div>
                </div>
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color7-card">
                        <i class="fa-solid fa-wallet fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color7-viewall" href="{{ route('creator_transaction.index')}}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter mt-4">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($CoinCurrentMounthCount ?? 0)}}">{{No_Format($CoinCurrentMounthCount ?? 0)}}</p>
                            <span>{{__('Label.creator_transactions')}} {{__('Label.monthly_earnings')}} ({{Currency_Code()}})</span>
                        </h2>
                    </div>
                </div>
                <div class="col-6 col-sm-4 col-md col-lg-4 col-xl">
                    <div class="db-color-card color9-card">
                        <i class="fa-solid fa-solid fa-box-archive fa-4x card-icon"></i>
                        <div class="dropdown dropright">
                            <a href="#" class="btn head-btn" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa-solid fa-ellipsis-vertical fa-xl text-dark dot-icon mr-2"></i>
                            </a>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                <a class="dropdown-item color9-viewall" href="{{ route('creator_package.index') }}">{{__('Label.View_All')}}</a>
                            </div>
                        </div>
                        <h2 class="counter">
                            <p class="p-0 m-0 counting" data-count="{{No_Format($CreatorPackageCount ?: 00)}}">{{No_Format($CreatorPackageCount ?: 00)}}</p>
                            <span>{{__('Label.creator_package')}}</span>
                        </h2>
                    </div>
                </div>
            </div>

            <!-- Top Creator -->
            <div class="row">
                <div class="col-12">
                    <div class="box-title">
                        <h2 class="title">{{__('Label.most_subscribed_creator')}}</h2>
                        <a href="{{ route('creator.index')}}" class="btn btn-link">{{__('Label.View_All')}}</a>
                    </div>
                    <div class="row artist-row">
                        @if(isset($most_subscribed_creator) && $most_subscribed_creator != null)
                        @for ($i = 0; $i < count($most_subscribed_creator); $i++) <div class="col-6 col-md-2">
                            <div class="artist-grid-card">
                                <span class="avatar-control">
                                    @isset($most_subscribed_creator[$i]->image )
                                    <img src="{{ $most_subscribed_creator[$i]->image }}" class="img-thumbnail" style="height: 180px; width: 100%; border-radius: 25px" />
                                    @else
                                    <img src="{{ asset('assets/imgs/default.png') }}" class="img-thumbnail" style="height: 180px; width: 100%; border-radius: 25px" />
                                    @endif
                                </span>
                                <h3 class="name" style="display: inline-block; text-overflow:ellipsis; white-space:nowrap; overflow:hidden; width:100%;">{{ $most_subscribed_creator[$i]->full_name ?? "-" }}</h3>
                                <p class="post mb-0">{{ String_Cut($most_subscribed_creator[$i]->bio, 30) }}</p>
                            </div>
                    </div>

                    @if($i == 5)
                    @break;
                    @endif
                    @endfor
                    @endif
                </div>
            </div>
            </div>

            <div class="row">
                <!-- Package Earning Statistice -->
                <div class="col-12">
                    <div class="box-title">
                        <h2 class="title">{{__('Label.coin_package_earning_statistice')}}</h2>
                        <a href="{{ route('coin_transaction.index') }}" class="btn btn-link">{{__('Label.View_All')}}</a>
                    </div>
                    <div class="row">
                        <div class="col-12 col-sm-12 mt-1">
                            <canvas id="MyChart" width="100%" height="38px" style="background-color: #f9faff;"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <!-- chart -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.js"></script>
    <script>
        var month = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        // Package Earning Statistice
        $(function() {
            //get the pie chart canvas
            var cData = JSON.parse(`<?php echo $package; ?>`);
            var ctx = $("#MyChart");
            var backcolor = ["#6D3A74", "#528BA6", "#2A445E", "#E99E75", "#00bfa0", "#9b19f5", "#ffa300", "#dc0ab4", "#7c1158", "#b30000"];

            const datasetValue = [];
            for (let i = 0; i < cData['label'].length; i++) {
                datasetValue[i] = {
                    label: cData['label'][i],
                    data: cData['sum'][i],
                    backgroundColor: backcolor[i],
                }
            }

            //bar chart data
            var data = {
                labels: month,
                datasets: datasetValue
            };

            //options
            var options = {
                responsive: true,
                title: {
                    display: true,
                    position: "top",
                    text: "{{__('Label.coin_package_earning_statistice_current_year')}}",
                    fontSize: 18,
                    fontColor: "#000"
                },
                legend: {
                    title: "text",
                    display: true,
                    position: 'top',
                    labels: {
                        fontSize: 16,
                        fontColor: "#000000",
                    }
                },
                scales: {
                    yAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Amount',
                            fontSize: 16,
                            fontColor: "#000000",
                        },
                    }],
                    xAxes: [{
                        scaleLabel: {
                            display: true,
                            labelString: 'Month',
                            fontSize: 16,
                            fontColor: "#000000",
                        }
                    }]
                }
            };

            //create bar Chart class object
            var chart1 = new Chart(ctx, {
                type: "bar",
                data: data,
                options: options
            });
        });
    </script>
@endsection