@extends('admin.layout.page-app')
@section('page_title', __('Label.report'))
@section('tab_title', __('Label.report'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('Label.report')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Label.report')}}</li>
                    </ol>
                </div>
            </div>

            <!-- Search && Table -->
            <div class="card custom-border-card mt-3">
                <div class="table-responsive table">
                    <table class="table table-striped text-center table-bordered" id="datatable">
                        <thead>
                            <tr style="background: #F9FAFF;">
                                <th>{{__('Label.#')}}</th>
                                <th>{{__('Label.User')}}</th>
                                <th>{{__('Label.Email')}}</th>
                                <th>{{__('Label.Mobile')}}</th>
                                <th>{{__('Label.post')}}</th>
                                <th>{{__('Label.reason')}}</th>
                                <th>{{__('Label.Action')}}</th>
                                <th>{{__('Label.is_read')}}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                responsive: true,
                autoWidth: false,
                language: {
                    paginate: {
                        previous: "<i class='fa-solid fa-chevron-left'></i>",
                        next: "<i class='fa-solid fa-chevron-right'></i>"
                    }
                },
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('report.index') }}",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'user.full_name',
                        name: 'user.full_name',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'user.email',
                        name: 'user.email',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'user.mobile_number',
                        name: 'user.mobile_number',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'post.title',
                        name: 'post.title',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'reason',
                        name: 'reason',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    {
                        data: 'status',
                        name: 'status',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'is_read',
                        name: 'is_read',
                        orderable: false,
                        searchable: false
                    },
                ],
            });
        });

        // artical status
        function changestatus(content_id, status) {
            var isAdmin = <?php echo Check_Admin_Access(); ?>;
            if (isAdmin == 1) {

                $("#dvloader").show();
                $.ajax({
                    url: '{{ route("report.status") }}',
                    type: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        id: content_id,
                        status: status
                    },
                    success: function(response) {
                        $("#dvloader").hide();
                        $('#datatable').DataTable().ajax.reload();
                    },
                    error: function(xhr, status, error) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        }
        // report status
        function change_status(id) {
            var isAdmin = <?php echo Check_Admin_Access(); ?>;
            if (isAdmin == 1) {
                $("#dvloader").show();
                $.ajax({
                    type: "GET",
                    url: "{{route('report.show', '')}}" + "/" + id,
                    data: id,
                    success: function(response) {
                        $("#dvloader").hide();
                        $('#datatable').DataTable().ajax.reload();
                    },
                    error: function(xhr, status, error) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
        };
    </script>
@endsection