<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\Admin\CommentController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\HashtagController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\PaymentController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\VideoController;
use App\Http\Controllers\Admin\ImageController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\Admin\CreatorController;
use App\Http\Controllers\Admin\BeComeCreatorController;
use App\Http\Controllers\Admin\GiftController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\WithdrawalController;
use App\Http\Controllers\Admin\WalletTransactionController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\AdmobController;
use App\Http\Controllers\Admin\CoinPackageController;
use App\Http\Controllers\Admin\CoinTransactionController;
use App\Http\Controllers\Admin\CreatorPackageController;
use App\Http\Controllers\Admin\CreatorTransactionController;
use App\Http\Controllers\Admin\FacebookAdsController;
use App\Http\Controllers\Admin\PostController;
use App\Http\Controllers\Admin\PriceListController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\ReportReasonController;
use App\Http\Controllers\Admin\StoryController;
use App\Http\Controllers\Admin\SystemSettingController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Artisan
Route::get('admin/artisan', function () {

    Artisan::call('config:clear');
    Artisan::call('config:cache');
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('view:cache');
    Artisan::call('route:clear');
    Artisan::call('route:cache');
    Artisan::call('optimize:clear');
    return "<h1>All Config Cache Clear Successfully.</h1>";
});

// Version
Route::get('version', function () {
    return "<h1>
        <li>PHP : " . phpversion() . "</li>
        <li>Laravel : " . app()->version() . "</li>
    </h1>";
});

Route::group(['middleware' => 'installation'], function () {

    // Login-Logout
    Route::get('admin/login', [AdminController::class, 'getLogin'])->name('admin.index');
    Route::post('admin/login', [AdminController::class, 'postLogin'])->name('admin.login');
    Route::get('admin/logout', [AdminController::class, 'logout'])->name('admin.logout');

    // chunk
    Route::any('saveChunk', [PostController::class, 'saveChunk']);
    Route::any('SaveChunkStory', [StoryController::class, 'SaveChunkStory']);

    Route::group(['prefix' => 'admin', 'middleware' => 'authadmin'], function () {

        Route::get('dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
        Route::get('dashboard/earning', [DashboardController::class, 'earningDashboard'])->name('earning.dashboard');
        // profile
        Route::resource('profile', ProfileController::class)->only(['store']);
        Route::post('profile/changepassword', [ProfileController::class, 'ChangePassword'])->name('profile.changepassword');
        // profile
        Route::resource('profile', ProfileController::class)->only(['index']);
        // hashtage
        Route::resource('hashtag', HashtagController::class)->only(['index', 'store', 'update']);
        // gift
        Route::resource('gift', GiftController::class)->only(['index', 'create', 'store', 'update']);
        // page
        Route::resource('page', PageController::class)->only(['index', 'store', 'edit', 'update']);
        // user
        Route::resource('user', UserController::class)->only(['index', 'create', 'store', 'edit', 'update']);
        // become creator
        Route::resource('becomecreator', BeComeCreatorController::class)->only(['index', 'show']);
        // creator
        Route::resource('creator', CreatorController::class)->only(['index', 'create', 'store', 'edit', 'update']);
        // post
        Route::resource('post', PostController::class)->only(['index', 'create', 'store', 'show', 'edit', 'update']);
        Route::get('post/content/{id}', [PostController::class, 'getpostcontent'])->name('postcontent.index');
        Route::post('post/content/save', [PostController::class, 'postcontentstore'])->name('postcontent.store');
        Route::post('post/content/delete', [PostController::class, 'postcontentdelete'])->name('postcontent.destroy');
        // Story
        Route::resource('story', StoryController::class)->only(['index', 'create', 'store', 'edit', 'update']);
        Route::get('story_status/{id}', [StoryController::class, 'changeStatus'])->name('story.status');
        // report reason
        Route::resource('reportreason', ReportReasonController::class)->only(['index', 'store', 'update']);
        // report 
        Route::resource('report', ReportController::class)->only(['index', 'show']);
        Route::post('report/status', [ReportController::class, 'changeStatus'])->name('report.status');
        // comment
        Route::resource('comment', CommentController::class)->only(['index', 'show']);
        // notification
        Route::resource('notification', NotificationController::class)->only(['index', 'create', 'store']);
        // creator package
        Route::resource('creator_package', CreatorPackageController::class)->only(['index', 'create', 'store', 'edit', 'update']);
        // creator transaction
        Route::resource('creator_transaction', CreatorTransactionController::class)->only(['index']);
        // Coin package
        Route::resource('coin_package', CoinPackageController::class)->only(['index', 'create', 'store', 'edit', 'update']);
        // Coin transaction
        Route::resource('coin_transaction', CoinTransactionController::class)->only(['index', 'create', 'store']);
        Route::any('search_user', [CoinTransactionController::class, 'searchUser'])->name('searchUser');
        // payment
        Route::resource('payment', PaymentController::class)->only(['index']);
        // Admob
        Route::resource('admob', AdmobController::class)->only(['index']);
        Route::post('admob/android', [AdmobController::class, 'admobAndroid'])->name('admob.android');
        Route::post('admob/ios', [AdmobController::class, 'admobIos'])->name('admob.ios');
        // facebook ads 
        Route::resource('fbads', FacebookAdsController::class)->only(['index']);
        Route::post('fbads/android', [FacebookAdsController::class, 'facebookadAndroid'])->name('fbads.android');
        Route::post('fbads/ios', [FacebookAdsController::class, 'facebookadIos'])->name('fbads.ios');
        // setting
        Route::get('setting', [SettingController::class, 'index'])->name('setting');
        Route::post('setting/app', [SettingController::class, 'App'])->name('settingApp');
        Route::post('setting/currency', [SettingController::class, 'Currency'])->name('settingCurrency');
        Route::post('setting/deepar', [SettingController::class, 'DeepAr'])->name('settingdeepar');
        Route::post('setting/vapidkey', [SettingController::class, 'VapIdKey'])->name('settingvapidkey');
        Route::post('setting/commission', [SettingController::class, 'Commission'])->name('settingCommission');
        Route::post('setting/livestreaming', [SettingController::class, 'liveStreaming'])->name('settingLiveStreaming');
        Route::post('setting/sightengine', [SettingController::class, 'SightEngine'])->name('settingSightengine');
        Route::post('setting/sociallink', [SettingController::class, 'SaveSocialLink'])->name('settingSocialLink');
        Route::post('setting/onboardingscreen/status', [SettingController::class, 'onboarding_screen_status'])->name('setting.onboardingscreen.status');
        Route::post('setting/onboardingscreen', [SettingController::class, 'OnboardingScreenUpdate'])->name('onboardingscreenupdate');
        Route::get('smtp/index', [SettingController::class, 'smtpIndex'])->name('smtpIndex');
        Route::post('setting/smtp', [SettingController::class, 'smtpsave'])->name('smtpsave');
        // widrawal
        Route::resource('withdrawal', WithdrawalController::class)->only(['index', 'show']);
        // System Setting
        Route::get('systemsetting', [SystemSettingController::class, 'index'])->name('system.setting.index');
        Route::post('systemsetting/cleardata', [SystemSettingController::class, 'ClearData'])->name('system.setting.cleardata');
        Route::post('systemsetting/cleandatabase', [SystemSettingController::class, 'CleanDatabase'])->name('system.setting.cleandatabase');

        Route::group(['middleware' => 'checkadmin'], function () {

            // gift
            Route::resource('gift', GiftController::class)->only(['destroy']);
            // user
            Route::resource('user', UserController::class)->only(['destroy']);
            // creater
            Route::resource('creator', CreatorController::class)->only(['destroy']);
            // post
            Route::resource('post', PostController::class)->only(['destroy']);
            // Story
            Route::resource('story', StoryController::class)->only(['show']);
            // report reason
            Route::resource('reportreason', ReportReasonController::class)->only(['destroy']);
            // notification
            Route::resource('notification', NotificationController::class)->only(['destroy']);
            Route::post('notification/setting', [NotificationController::class, 'settingsave'])->name('notification.settingsave');
            Route::get('notification/setting', [NotificationController::class, 'setting'])->name('notification.setting');
            //  Creator package
            Route::resource('creator_package', CreatorPackageController::class)->only(['destroy']);
            //  Creator transaction
            Route::resource('coin_transaction', CoinTransactionController::class)->only(['destroy']);
            //  Coin package
            Route::resource('coin_package', CoinPackageController::class)->only(['destroy']);
            // Coin transaction
            Route::resource('creator_transaction', CoinTransactionController::class)->only(['destroy']);
            // payment
            Route::resource('payment', PaymentController::class)->only(['edit', 'update']);
            // System Setting
            Route::get('systemsetting/downloadsqlfile', [SystemSettingController::class, 'DownloadSqlFile'])->name('system.setting.downloadsqlfile');
        });
    });
});
