<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Creator_Request;
use App\Models\Common;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Exception;

class BeComeCreatorController extends Controller
{
    private $folder_user = "user";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index(Request $request)
    {
        try {
            $params['data'] = [];
            if ($request->ajax()) {

                $data = Creator_Request::with('user')->latest()->get();
                $this->common->imageNameToUrl($data, 'front_id_proof_img', $this->folder_user);
                $this->common->imageNameToUrl($data, 'back_id_proof_img', $this->folder_user);

                for ($i = 0; $i < count($data); $i++) {
                    if ($data[$i]['user'] != null) {
                        $this->common->imageNameToUrl(array($data[$i]['user']), 'image', $this->folder_user);
                    }
                }

                return DataTables()::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function ($row) {
                        $btn = "<button type='button' id='$row->id' onclick='change_status($row->id, 1)' style='background:#058f00; font-weight:bold; border: none; color: white; padding: 5px 20px; outline: none; border-radius: 5px; cursor: pointer; margin-right: 5px;'> " . __('Label.accept') . "</button>";

                        $btn .= "<button type='button' id='$row->id' onclick='change_status($row->id, 0)' style='background:#e3000b; font-weight:bold; border: none; color: white; padding: 5px 20px; outline: none; border-radius: 5px; cursor: pointer;'>  " . __('Label.reject') . " </button>";
                        return $btn;
                    })
                    ->addColumn('date', function ($row) {
                        $date = date("Y-m-d", strtotime($row->created_at));
                        return $date;
                    })

                    ->rawColumns(['action', 'proof'])
                    ->make(true);
            }
            return view('admin.become_creator.index', $params);
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
    public function show(Request $request)
    {
        try {
            $id = $request['id'];
            $status = $request['status'];

            $data = creator_request::where('id', $id)->first();
            if ($status == 1 && isset($data)) {

                $user_id = $data['user_id'];
                User::where('id', $user_id)->update([
                    'bank_name' => $data['bank_name'],
                    'account_no' => $data['account_no'],
                    'ifsc_no' => $data['ifsc_no'],
                    'front_id_proof_img' => $data['front_id_proof_img'],
                    'back_id_proof_img' => $data['back_id_proof_img'],
                    'is_creator' => 1,
                ]);

                // Send Mail & Notification
                $user = User::where('id', $user_id)->first();
                if (isset($user) && $user != null) {

                    $this->common->Send_Mail(5, $user->email);

                    $title = __('Label.congratulations_your_creator_request_has_been_approved');
                    $this->common->save_notification(9, 0, $user_id, 0, $title);
                }

                $data->delete();
            } else if ($status == 0 && isset($data)) {

                $user_id = $data['user_id'];
                $this->common->deleteImageToFolder($this->folder_user, $data['front_id_proof_img']);
                $this->common->deleteImageToFolder($this->folder_user, $data['back_id_proof_img']);
                $data->delete();

                // Send Mail & Notification
                $user = User::where('id', $user_id)->first();
                if (isset($user) && $user != null) {

                    $this->common->Send_Mail(6, $user->email);

                    $title = __('Label.sorry_your_creator_request_has_been_rejected');
                    $this->common->save_notification(9, 0, $user_id, 0, $title);
                }
            }
            return response()->json(array('status' => 200, 'success' => __('Label.request_updated_successfully')));
        } catch (Exception $e) {
            return response()->json(array('status' => 400, 'errors' => $e->getMessage()));
        }
    }
}
