@extends('admin.layout.page-app')
@section('page_title', __('Label.coin_transactions'))
@section('tab_title', __('Label.coin_transactions'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"> {{__('Label.coin_transactions')}} </h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-10">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Label.coin_transactions')}}</li>
                    </ol>
                </div>
                <div class="col-sm-2 d-flex align-items-center justify-content-end">
                    <a href="{{ route('coin_transaction.create') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.add_coin_transaction')}}</a>
                </div>
            </div>

            <!-- Search -->
            <div class="page-search mb-3">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text" id="basic-addon1">
                            <i class="fa-solid fa-magnifying-glass fa-xl light-gray"></i>
                        </span>
                    </div>
                    <input type="text" id="input_search" class="form-control" placeholder="{{__('Label.search_by_transaction_id')}}" aria-label="Search" aria-describedby="basic-addon1">
                </div>
                <div class="sorting mr-3">
                    <label>{{__('Label.sort_by')}}</label>
                    <select class="form-control" id="input_type">
                        <option value="all">{{__('Label.all')}}</option>
                        <option value="today">{{__('Label.today')}}</option>
                        <option value="month">{{__('Label.month')}}</option>
                        <option value="year">{{__('Label.year')}}</option>
                    </select>
                </div>
            </div>

            <div class="table-responsive table">
                <table class="table table-striped text-center table-bordered" id="datatable">
                    <thead>
                        <tr style="background: #F9FAFF;">
                            <th> {{__('Label.#')}} </th>
                            <th> {{__('Label.Image')}} </th>
                            <th> {{__('Label.User')}} </th>
                            <th> {{__('Label.coin_package')}} </th>
                            <th> {{__('Label.Price')}} </th>
                            <th> {{__('Label.coin')}} </th>
                            <th> {{__('Label.transaction_id')}} </th>
                            <th> {{__('Label.Description')}} </th>
                            <th> {{__('Label.Date')}} </th>
                            <th> {{__('Label.Action')}} </th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                    <tfoot>
                        <tr style="background: #F9FAFF;">
                            <td colspan="10" class="text-center"></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        // Sidebar Scroll Down
		sidebar_down($(document).height());
        var defaultImagePath = "{{ asset('assets/imgs/default.png') }}";

        $(document).ready(function() {
            var table = $('#datatable').DataTable({
                ...dataTableDefaults,
                ajax: {
                    url: "{{ route('coin_transaction.index') }}",
                    data: function(d) {
                        d.input_type = $('#input_type').val();
                        d.input_search = $('#input_search').val();
                    },
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex'
                    },
                    {
                        data: 'user.image',
                        name: 'user.image',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return "<a href='" + data + "' target='_blank' title='Watch'><img src='" + data + "' class='rounded-circle' style='height:55px; width:55px'></a>";
                            } else {
                                return "<img src='" + defaultImagePath + "' class='rounded-circle' style='height:55px; width:55px'>";
                            }
                        },
                    },
                    {
                        data: 'user.full_name',
                        name: 'user.full_name',
                        orderable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'coin_package.name',
                        name: 'coin_package.name',
                        orderable: false,
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'price',
                        name: 'price',
                        render: function(data) {
                            return data ? data : 0;
                        }
                    },
                    {
                        data: 'coin',
                        name: 'coin',
                        render: function(data) {
                            return data ? data : 0;
                        }
                    },
                    {
                        data: 'transaction_id',
                        name: 'transaction_id',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'description',
                        name: 'description',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        },
                    },
                    {
                        data: 'date',
                        name: 'date',
                        render: function(data, type, full, meta) {
                            if (data) {
                                return data;
                            } else {
                                return "-";
                            }
                        }
                    },
                    { data: 'action', name: 'action', orderable: false, searchable: false },
                ],
                footerCallback: function ( row, data, start, end, display ) {
                    var api = this.api(), data;

                    // converting to interger to find total
                    var intVal = function ( i ) {
                        return typeof i === 'string' ? i.replace(/[\$,]/g, '')*1 : typeof i === 'number' ? i : 0;
                    };

                    // computing column Total of the complete result 
                    var Total = api
                        .column(4)
                        .data()
                        .reduce( function (a, b) {
                            return intVal(a) + intVal(b);
                        }, 0 );

                    // Update footer by showing the total with the reference of the column index 
                    $(api.column(1).footer() ).html("Total Amount =&nbsp &nbsp {{Currency_Code() }}"+ " " + Total);
                },
            });

            $('#input_type').change(function() {
                table.draw();
            });
            $('#input_search').keyup(function() {
                table.draw();
            });
        });
    </script>
@endsection