@extends('admin.layout.page-app')
@section('page_title',  __('Label.edit_creator'))
@section('tab_title', __('Label.edit_creator'))

@section('content')
	@include('admin.layout.sidebar')

	<div class="right-content">
		@include('admin.layout.header')

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm">{{__('Label.edit_creator')}}</h1>

			<div class="border-bottom row mb-3">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item">
							<a href="{{ route('admin.dashboard') }}">{{__('Label.Dashboard')}}</a>
						</li>
						<li class="breadcrumb-item">
							<a href="{{ route('creator.index') }}">{{__('Label.Creator')}}</a>
						</li>
						<li class="breadcrumb-item active" aria-current="page">{{__('Label.edit_creator')}}</li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center justify-content-end">
					<a href="{{ route('creator.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('Label.creator_list')}}</a>
				</div>
			</div>

			<div class="card custom-border-card mt-3">
				<form id="creator_update" enctype="multipart/form-data"  autocomplete="off">
					<input type="hidden" name="id" value="@if($data){{$data->id}}@endif">
					<div class="form-row">
						<div class="col-md-6">
							<div class="form-row">
								<div class="col-md-6">
									<div class="form-group">
										<label>{{__('Label.Full_Name')}}<span class="text-danger">*</span></label>
										<input type="text" value="@if($data){{$data->full_name}}@endif" name="full_name" class="form-control" placeholder="{{__('Label.full_name_here')}}" autofocus>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group">
										<label>{{__('Label.Email')}}<span class="text-danger">*</span></label>
										<input type="email" value="@if($data){{$data->email}}@endif" name="email" class="form-control" placeholder="{{__('Label.email_here')}}">
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-3">
									<div class="form-group">
										<label>{{__('Label.country_code')}}<span class="text-danger">*</span></label>
										<input type="text" value="@if($data){{$data->country_code}}@endif" name="country_code" class="form-control" placeholder="{{__('Label.+91')}}">
									</div>
                                </div>
								<div class="col-md-6">
									<div class="form-group">
										<label>{{__('Label.Mobile Number')}}<span class="text-danger">*</span></label>
										<input type="text" value="@if($data){{$data->mobile_number}}@endif" name="mobile_number" class="form-control" placeholder="{{__('Label.mobile_number_here')}}">
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group">
										<label>{{__('Label.country_name')}}<span class="text-danger">*</span></label>
										<input type="text" value="@if($data){{$data->country_name}}@endif" name="country_name" class="form-control" placeholder="{{__('Label.ind')}}">
									</div>
                                </div>
							</div>
							<div class="form-row">
								<div class="col-md-6">
									<div class="form-group">
										<label>{{__('Label.Gender')}}<span class="text-danger">*</span></label>
										<select name="gender" class="form-control">
											<option value="Male" {{ $data->gender == "Male" ? 'selected' : '' }}>{{__('Label.male')}}</option>
											<option value="Female" {{ $data->gender == "Female" ? 'selected' : '' }}>{{__('Label.female')}}</option>
											<option value="Other" {{ $data->gender == "Other" ? 'selected' : '' }}>{{__('Label.other')}}</option>
										</select>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group">
										<label>{{__('Label.Date_Of_Birth')}}<span class="text-danger">*</span></label>
										<input type="date" name="date_of_birth" max="<?php echo date('Y-m-d'); ?>" value="@if($data){{$data->date_of_birth}}@endif" class="form-control">
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-9">
									<div class="form-group">
										<label>{{__('Label.Bio')}}</label>
										<textarea name="bio" class="form-control" rows="1" placeholder="{{__('Label.describe_here')}}.">@if($data){{$data->bio}}@endif</textarea>
									</div>
								</div>
								<div class="col-md-3">
                                    <div class="form-group ml-3">
                                        <label for="is_verified_at">{{__('Label.is_verified')}}<span class="text-danger">*</span></label>
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="is_verified_at" name="is_verified_at" class="custom-control-input"  {{ ($data['is_verified_at']=='1')? "checked" : "" }} value="1">
                                                <label class="custom-control-label" for="is_verified_at">{{__('Label.Yes')}}</label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" id="is_verified_at1" name="is_verified_at" class="custom-control-input" {{ ($data['is_verified_at']=='0')? "checked" : "" }} value="0">
                                                <label class="custom-control-label" for="is_verified_at1">{{__('Label.No')}}</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
							</div>
						</div>
						<div class="col-md-3">
                            <div class="form-group ml-5">
                                <label>{{__('Label.portrait_image')}}<span class="text-danger">*</span></label>
                                <div class="avatar-upload">
                                    <div class="avatar-edit">
                                        <input type='file' name="image" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                        <label for="imageUpload" title="Select File"></label>
                                    </div>
                                    <div class="avatar-preview">
                                        <img src="{{$data['image']}}" alt="upload_img.png" id="imagePreview">
                                    </div>
                                </div>
								<input type="hidden" name="old_image" value="@if($data){{$data->image}}@endif">
                                <label class="mt-3 text-gray">{{__('Label.maximum_size')}}</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group ml-5">
                                <label>{{__('Label.cover_image')}}<span class="text-danger">*</span></label>
                                <div class="avatar-upload-landscape">
                                    <div class="avatar-edit-landscape">
                                        <input type='file' name="cover_img" id="imageUploadLandscape" accept=".png, .jpg, .jpeg" />
                                        <label for="imageUploadLandscape" title="Select File"></label>
                                    </div>
                                    <div class="avatar-preview-landscape">
                                        <img src="{{$data['cover_img']}}" alt="upload_img.png" id="imagePreviewLandscape">
                                    </div>
                                </div>
								<input type="hidden" name="old_cover_image" value="@if($data){{$data->cover_img}}@endif">
                                <label class="mt-3 text-gray">{{__('Label.maximum_size')}}</label>
                            </div>
                        </div>
					</div>
					<div class="form-row">
						<div class="col-md-3">
							<div class="form-group">
								<label>{{__('Label.facebook_url')}}</label>
								<input type="text" name="facebook_url" value="@if($data){{$data->facebook_url}}@endif" class="form-control" placeholder="{{__('Label.enter_url')}}">
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<label>{{__('Label.instagram_url')}}</label>
								<input type="text" name="instagram_url" value="@if($data){{$data->instagram_url}}@endif" class="form-control" placeholder="{{__('Label.enter_url')}}">
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<label>{{__('Label.youtube_url')}}</label>
								<input type="text" name="youtube_url" value="@if($data){{$data->youtube_url}}@endif" class="form-control" placeholder="{{__('Label.enter_url')}}">
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group">
								<label>{{__('Label.twitter_url')}}</label>
								<input type="text" name="twitter_url" value="@if($data){{$data->twitter_url}}@endif" class="form-control" placeholder="{{__('Label.enter_url')}}">
							</div>
						</div>
					</div>
					<div class="border-top pt-3 text-right">
						<button type="button" class="btn btn-default mw-120" onclick="update_creator()">{{__('Label.UPDATE')}}</button>
						<a href="{{route('creator.index')}}" class="btn btn-cancel mw-120 ml-2">{{__('Label.CANCEL')}}</a>
						<input type="hidden" name="_method" value="PATCH">
					</div>
				</form>
			</div>
		</div>
	</div>
@endsection

@section('pagescript')
	<script>
		function update_creator(){
			var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

				$("#dvloader").show();
				var formData = new FormData($("#creator_update")[0]);
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					enctype: 'multipart/form-data',
					type: 'POST',
					url: '{{route("creator.update", [$data->id])}}',
					data: formData,
					cache:false,
					contentType: false,
					processData: false,
					success:function(resp){
						$("#dvloader").hide();
						get_responce_message(resp, 'creator_update', '{{ route("creator.index") }}');
					},
					error: function(XMLHttpRequest, textStatus, errorThrown) {
						$("#dvloader").hide();
						toastr.error(errorThrown, textStatus);         
					}
				});
			} else {
                toastr.error('{{__("Label.you_have_no_right_to_add_edit_and_delete")}}');
            }
		}
	</script>
@endsection